﻿using AZVIC.Ei8htPOS.BAL;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.POSRetail.Constants;
using AZVIC.Ei8htPOS.POSRetail.Controls.Loading;
using AZVIC.Ei8htPOS.POSRetail.Helpers;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace AZVIC.Ei8htPOS.POSRetail.Pages
{
    /// <summary>
    /// Interaction logic for PendingTransactions.xaml
    /// </summary>
    public partial class PendingTransactions : Page
    {
        private static List<Orders> CurrentOrders;
        public PendingTransactions()
        {
            InitializeComponent();
            dtStartDate.SelectedDate = dtEndDate.SelectedDate = DateTime.Now;
            LoadPendingTransactions(string.Empty, DateTime.Now, DateTime.Now, 'A');
        }

        private void chk_Checked(object sender, RoutedEventArgs e)
        {
            //if (((sender) as CheckBox).Name == chkPOS.Name)
            //{
            //    chkWeb.IsChecked = false;
            //}
            //else
            //{
            //    chkPOS.IsChecked = false;
            //}
        }

        private void btnExport_Click(object sender, RoutedEventArgs e)
        {
            ExcelExportHelper.Export(gvPendingTransactions, "PendingTransactions");
        }

        private void LoadPendingTransactions(string Keyword, DateTime StartDate, DateTime EndDate, char OrderFromFlag)
        {
            ProgressDialogResult result = ProgressDialog.Execute(Application.Current.MainWindow, string.Empty, (bw, we) =>
             {
                 List<Orders> pcList = OrdersBL.GetList(Guid.Empty, Guid.Empty, Keyword, StartDate, EndDate);
                 if (pcList != null && pcList.Count > 0)
                 {
                     pcList = pcList.Where(a => a.IsActive).ToList<Orders>();
                 }
                 string OrderedFrom = OrderFromFlag == 'A' ? "All" : (OrderFromFlag == 'P' ? "POS" : "Web");
                 //Select Only Pending Orders and Selected Order Source - POS, Web or Both
                 if (OrderedFrom != "All")
                     pcList = (from pl in pcList
                               orderby pl.OrderNumber descending
                               where (((pl.OrderStatus.ToLower() == "pending" || pl.OrderStatus.ToLower() == "new") && pl.PaymentStatus.ToLower() == "pending") &&
                                pl.OrderFrom == OrderedFrom)
                               select pl).ToList<Orders>();
                 else
                     pcList = (from pl in pcList
                               orderby pl.OrderNumber descending
                               where ((pl.OrderStatus.ToLower() == "pending" || pl.OrderStatus.ToLower() == "new") && pl.PaymentStatus.ToLower() == "pending")
                               select pl).ToList<Orders>();
                 gvPendingTransactions.Dispatcher.BeginInvoke(new Action(() => gvPendingTransactions.ItemsSource = pcList));
                 CurrentOrders = pcList;
             });
        }

        private void btnSearch_Click(object sender, RoutedEventArgs e)
        {
            LoadPendingTransactions(txtSearch.Text.Trim(), dtStartDate.SelectedDate != null ? dtStartDate.SelectedDate.Value : DateTime.MinValue,
                dtEndDate.SelectedDate != null ? dtEndDate.SelectedDate.Value : DateTime.MinValue, 'A');
        }

        private void gvPendingTransactions_MouseDoubleClick(object sender, MouseButtonEventArgs e)
        {
            if (sender != null)
            {
                if (gvPendingTransactions != null && gvPendingTransactions.SelectedItems != null && gvPendingTransactions.SelectedItems.Count == 1)
                {
                    DataGridRow dgr = gvPendingTransactions.ItemContainerGenerator.ContainerFromItem(gvPendingTransactions.SelectedItem) as DataGridRow;
                    AppSession.CurrentOrders = dgr.DataContext as Orders;
                    AppSession.CurrentUser = (AppSession.CurrentOrders.UsersAccountID != null && AppSession.CurrentOrders.UsersAccountID != Guid.Empty ? UserAccountBL.GetItem(AppSession.CurrentOrders.UsersAccountID, string.Empty, string.Empty, string.Empty, DateTime.MinValue, DateTime.MinValue) : null);
                    MasterWindow Master = new MasterWindow();
                    Master.LoadPages(new Ordering(), Menus.ORDER);
                }
            }
        }

        private void SelectButton_Click(object sender, RoutedEventArgs e)
        {
            Button SelectedTransaction = sender as Button;
            DataGridRow dgr = GetParent(SelectedTransaction);
            AppSession.CurrentOrders = dgr.DataContext as Orders;
            AppSession.CurrentUser = (AppSession.CurrentOrders.UsersAccountID != null && AppSession.CurrentOrders.UsersAccountID != Guid.Empty ? UserAccountBL.GetItem              (AppSession.CurrentOrders.UsersAccountID, string.Empty, string.Empty, string.Empty, DateTime.MinValue, DateTime.MinValue) : null);
            MasterWindow Master = new MasterWindow();
            Master.LoadPages(new Ordering(), Menus.ORDER);
        }

        private DataGridRow GetParent(DependencyObject dep)
        {
            DependencyObject Obj = null;
            if (dep.GetType() == typeof(DataGridRow))
            {
                Obj = dep as DataGridRow;
            }
            else
            {
                Obj = GetParent(VisualTreeHelper.GetParent(dep));
            }
            return Obj as DataGridRow;
        }

        private void btnClearTransaction_Click(object sender, RoutedEventArgs e)
        {
            ProgressDialogResult result = ProgressDialog.Execute(Application.Current.MainWindow, string.Empty, (bw, we) =>
             {
                 foreach (Orders ord in CurrentOrders)
                 {
                     ord.OrderStatus = "Canceled";
                     OrdersBL.Save(ord);
                 }

             });
            LoadPendingTransactions(txtSearch.Text.Trim(), dtStartDate.SelectedDate != null ? dtStartDate.SelectedDate.Value : DateTime.MinValue,
               dtEndDate.SelectedDate != null ? dtEndDate.SelectedDate.Value : DateTime.MinValue, 'A');


        }

        private void Clear_Click(object sender, RoutedEventArgs e)
        {
            if (AppSession.CurrentAdminUser.UserRoleType.ToLower().Equals("superadmin"))
            {
                if(App.ConfirmationDialog("Do you want to clear the transaction?","Ei8ht POS"))
                {
                Button SelectedTransaction = sender as Button;
                DataGridRow dgr = GetParent(SelectedTransaction);
                Orders curOrders = dgr.DataContext as Orders;
                curOrders.OrderStatus = "Canceled";
                OrdersBL.Save(curOrders);

                if ((!string.IsNullOrEmpty(txtSearch.Text)) || (dtStartDate.SelectedDate != null) || (dtEndDate.SelectedDate != null))
                    LoadPendingTransactions(txtSearch.Text.Trim(), dtStartDate.SelectedDate != null ? dtStartDate.SelectedDate.Value : DateTime.MinValue,
                       dtEndDate.SelectedDate != null ? dtEndDate.SelectedDate.Value : DateTime.MinValue, 'A');
                else
                    LoadPendingTransactions(string.Empty, DateTime.Now, DateTime.Now, 'A');
                }
            }
            else
            {
                MessageBox.Show("You don't have permission to void a transaction. Please contact the administrator");
            }
        }
    }
}
